/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import org.adempiere.base.annotation.Process;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

@Process
public class RecreateStorageReservation
extends SvrProcess {
    private int m_AD_Client_ID = 0;

    @Override
    protected void prepare() {
        this.m_AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
    }

    @Override
    protected String doIt() throws Exception {
        int wrongReservations = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ( SELECT SUM(ol.QtyReserved) AS OrderQtyReserved,        ol.M_Warehouse_ID,        ol.M_Product_ID,        COALESCE(ol.M_AttributeSetInstance_ID, 0) AS M_AttributeSetInstance_ID,        o.IsSOTrx,        w.AD_Client_ID,        w.AD_Org_ID FROM   C_OrderLine ol        JOIN C_Order o ON ( ol.C_Order_ID = o.C_Order_ID )        JOIN M_Warehouse w ON ( w.M_Warehouse_ID = o.M_Warehouse_ID )        JOIN M_Product p ON ( p.M_Product_ID = ol.M_Product_ID ) WHERE  ol.AD_Client_ID = ?        AND p.IsStocked='Y'        AND ol.QtyReserved != 0        AND o.DocStatus NOT IN ( 'VO', 'RE' ) GROUP  BY ol.M_Warehouse_ID,           ol.M_Product_ID,           COALESCE(ol.M_AttributeSetInstance_ID, 0),           o.IsSOTrx,           w.AD_Client_ID,           w.AD_Org_ID ) y FULL OUTER JOIN ( SELECT Qty AS StorageQtyreserved,        M_Warehouse_ID,        M_Product_ID,        M_AttributeSetInstance_ID,        IsSOTrx,        AD_Client_ID FROM   M_StorageReservation WHERE  AD_Client_ID = ?        AND Qty != 0 ) x     ON y.M_Warehouse_ID = x.M_Warehouse_ID        AND x.M_Product_ID = y.M_Product_ID        AND x.M_AttributeSetInstance_ID = y.M_AttributeSetInstance_ID        AND x.IsSOTrx = y.IsSOTrx WHERE  COALESCE(x.StorageQtyReserved, 0) <> COALESCE(y.OrderQtyReserved, 0)", this.m_AD_Client_ID, this.m_AD_Client_ID);
        int noInserted = 0;
        if (wrongReservations > 0) {
            this.log.warning(wrongReservations + " wrong reservation records found");
            int no = DB.executeUpdateEx("DELETE FROM M_StorageReservation WHERE AD_Client_ID=?", new Object[]{this.m_AD_Client_ID}, this.get_TrxName());
            this.log.warning(no + " reservation records deleted");
            noInserted = DB.executeUpdateEx("INSERT INTO M_StorageReservation             (Qty,              M_Warehouse_ID,              M_Product_ID,              M_AttributeSetInstance_ID,              IsSOTrx,              AD_Client_ID,              AD_Org_ID,              Created,              CreatedBy,              Updated,              UpdatedBy,              IsActive,              M_StorageReservation_UU) SELECT SUM(ol.QtyReserved) AS OrderQtyReserved,        ol.M_Warehouse_ID,        ol.M_Product_ID,        COALESCE(ol.M_AttributeSetInstance_ID, 0),        o.IsSOTrx,        w.AD_Client_ID,        w.AD_Org_ID,        getDate(),        ?,        getDate(),        ?,        'Y',        generate_uuid() FROM   C_OrderLine ol        JOIN C_Order o ON ( ol.C_Order_ID = o.C_Order_ID )        JOIN M_Warehouse w ON ( w.M_Warehouse_ID = o.M_Warehouse_ID )        JOIN M_Product p ON ( p.M_Product_ID = ol.M_Product_ID ) WHERE  p.IsStocked='Y'        AND ol.QtyReserved != 0        AND o.DocStatus NOT IN ( 'VO', 'RE' )        AND o.AD_Client_ID = ? GROUP  BY ol.M_Warehouse_ID,        ol.M_Product_ID,        COALESCE(ol.M_AttributeSetInstance_ID, 0),        o.IsSOTrx,        w.AD_Client_ID,        w.AD_Org_ID", new Object[]{Env.getAD_User_ID(this.getCtx()), Env.getAD_User_ID(this.getCtx()), this.m_AD_Client_ID}, this.get_TrxName());
            this.log.warning(noInserted + " reservation records inserted");
        }
        return noInserted + " @Inserted@";
    }
}

